// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     chrome/common/resource_usage_reporter.mojom
//

package org.chromium.mojom;

public final class ResourceTypeStat extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 40;
    private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(40, 0)};
    private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

    public long count;
    public long size;
    public long liveSize;
    public long decodedSize;

    private ResourceTypeStat(int version) {
        super(STRUCT_SIZE, version);
        count = (long) 0L;
        size = (long) 0L;
        liveSize = (long) 0L;
        decodedSize = (long) 0L;
    }

    public ResourceTypeStat() {
        this(0);
    }

    public static ResourceTypeStat deserialize(org.chromium.mojo.bindings.Message message) {
        return decode(new org.chromium.mojo.bindings.Decoder(message));
    }

    @SuppressWarnings("unchecked")
    public static ResourceTypeStat decode(org.chromium.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
        ResourceTypeStat result = new ResourceTypeStat(mainDataHeader.elementsOrVersion);
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.count = decoder0.readLong(8);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.size = decoder0.readLong(16);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.liveSize = decoder0.readLong(24);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.decodedSize = decoder0.readLong(32);
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        encoder0.encode(count, 8);
        encoder0.encode(size, 16);
        encoder0.encode(liveSize, 24);
        encoder0.encode(decodedSize, 32);
    }

    /**
     * @see Object#equals(Object)
     */
    @Override
    public boolean equals(Object object) {
        if (object == this)
            return true;
        if (object == null)
            return false;
        if (getClass() != object.getClass())
            return false;
        ResourceTypeStat other = (ResourceTypeStat) object;
        if (this.count != other.count)
            return false;
        if (this.size != other.size)
            return false;
        if (this.liveSize != other.liveSize)
            return false;
        if (this.decodedSize != other.decodedSize)
            return false;
        return true;
    }

    /**
     * @see Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = prime + getClass().hashCode();
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(count);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(size);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(liveSize);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(decodedSize);
        return result;
    }
}

